# Next.js SSR App for cPanel Deployment

This is a Next.js application configured for Server-Side Rendering (SSR) and optimized for deployment on cPanel Node.js hosting.

## Features

- ✅ **True Server-Side Rendering (SSR)** - Pages are dynamically rendered on each request
- ✅ **Real-time Data** - Server timestamps and request info updated per visit
- ✅ **TypeScript Support** - Full TypeScript configuration for type safety
- ✅ **cPanel Node.js Ready** - Optimized for cPanel Node.js hosting
- ✅ **Custom Server** - Production-ready Node.js server with `server.js`
- ✅ **API Routes** - Full backend API functionality
- ✅ **Dynamic Content** - `getServerSideProps` for request-time data fetching
- ✅ **Responsive Design** - Mobile-friendly styling

## Getting Started

### Development

1. **Install dependencies:**

   ```bash
   npm install
   ```

2. **Run the development server:**

   ```bash
   npm run dev
   ```

3. **Open your browser:**
   Navigate to [http://localhost:3000](http://localhost:3000)

### Building for Production

```bash
npm run build
```

## cPanel Deployment Guide

### Prerequisites

- cPanel hosting with Node.js support (version 18+)
- SSH access or file manager access
- Domain or subdomain configured

### Step-by-Step Deployment

1. **Prepare the application:**

   ```bash
   ./deploy.sh
   ```

2. **Upload files to cPanel:**

   - Upload all project files to your Node.js app directory
   - Common paths: `/public_html/nodejs/your-app-name/`

3. **Configure Node.js app in cPanel:**

   - Go to "Node.js Selector" in cPanel
   - Create a new Node.js app or select existing
   - Set **Startup File**: `server.js`
   - Set **Node.js Version**: 18.x or higher
   - Set **Application Root**: Path to your uploaded files
   - Set **Application URL**: Your desired subdirectory (optional)

4. **Environment Configuration:**

   - Copy `env.example` to `.env.local`
   - Update environment variables:
     ```bash
     NODE_ENV=production
     PORT=3000
     HOSTNAME=your-domain.com
     ```

5. **Install dependencies on server:**

   - Use cPanel terminal or SSH:
     ```bash
     cd /path/to/your/app
     npm install --production
     ```

6. **Start the application:**
   - Click "Start" in the Node.js Selector interface
   - Your app will be available at your configured URL

### Subdirectory Deployment

If deploying to a subdirectory (e.g., `yourdomain.com/myapp`):

1. **Update `next.config.js`:**

   ```javascript
   const nextConfig = {
     basePath: "/myapp",
     // ... other config
   };
   ```

2. **Update environment:**
   ```bash
   NEXT_PUBLIC_BASE_PATH=/myapp
   ```

## Project Structure

```
├── pages/              # Next.js pages (SSR enabled)
│   ├── _app.tsx       # App wrapper
│   ├── _document.tsx  # HTML document structure
│   ├── index.tsx      # Home page with SSR
│   ├── about.tsx      # About page with SSR
│   └── api/           # API routes
│       └── hello.ts   # Sample API endpoint
├── styles/            # CSS styles
│   ├── globals.css    # Global styles
│   └── Home.module.css # Component styles
├── server.js          # Custom Node.js server
├── next.config.js     # Next.js configuration
├── package.json       # Dependencies and scripts
├── tsconfig.json      # TypeScript configuration
└── deploy.sh          # Deployment script
```

## Available Scripts

- `npm run dev` - Start development server with SSR
- `npm run build` - Build for production with SSR support
- `npm start` - Start production server (uses server.js)
- `npm run cpanel-deploy` - Build for cPanel deployment

## SSR Implementation

The application uses `getServerSideProps` for server-side rendering:

```typescript
export const getServerSideProps: GetServerSideProps = async ({ req }) => {
  // Server-side logic here
  return {
    props: {
      // Props passed to component
    },
  };
};
```

## API Routes

API endpoints are available at `/api/*`:

- `GET /api/hello` - Sample API endpoint

## Troubleshooting

### Common Issues

1. **Port conflicts:**

   - Update `PORT` in `.env.local`
   - Ensure port is available in cPanel

2. **Path issues:**

   - Check `basePath` in `next.config.js`
   - Verify file permissions on server

3. **Dependencies:**

   - Run `npm install --production` on server
   - Check Node.js version compatibility

4. **Build errors:**
   - Check TypeScript errors: `npm run build`
   - Verify all imports and exports

### Support

For deployment issues:

- Check cPanel error logs
- Verify Node.js app configuration
- Ensure all files are uploaded correctly
- Contact your hosting provider for Node.js specific issues

## License

This project is open source and available under the [MIT License](LICENSE).
