#!/bin/bash

# Deployment script for cPanel Node.js SSR hosting
# Make sure to run: chmod +x deploy.sh

echo "🚀 Starting SSR deployment process..."

# Install dependencies
echo "📦 Installing dependencies..."
npm install --production

# Build the application for SSR
echo "🔨 Building the SSR application..."
npm run build

# Create production environment file if it doesn't exist
if [ ! -f .env.local ]; then
    echo "📝 Creating .env.local from example..."
    cp env.example .env.local
    echo "⚠️  Please update .env.local with your production settings"
fi

echo "✅ SSR deployment preparation complete!"
echo ""
echo "📋 Next steps for cPanel SSR deployment:"
echo "1. Upload all files to your Node.js app directory"
echo "2. Set the startup file to: server.js"
echo "3. Set Node.js version to 18 or higher"
echo "4. Update .env.local with your production settings"
echo "5. Start the application in cPanel Node.js interface"
echo ""
echo "🌐 Your SSR app will be available at your domain/subdirectory"
echo "✨ Pages will be server-side rendered on each request!"
