import { GetServerSideProps } from "next";
import Head from "next/head";
import Link from "next/link";
import styles from "../styles/Home.module.css";

interface AboutProps {
  renderTime: string;
  requestCount: number;
}

let requestCounter = 0;

export default function About({ renderTime, requestCount }: AboutProps) {
  return (
    <div className={styles.container}>
      <Head>
        <title>About - Next.js SSR Demo</title>
        <meta name="description" content="About page demonstrating SSR" />
      </Head>

      <main className={styles.main}>
        <h1 className={styles.title}>About This SSR Demo</h1>

        <p className={styles.description}>
          This page demonstrates server-side rendering in Next.js
        </p>

        <div className={styles.grid}>
          <div className={styles.card}>
            <h2>Server-Side Rendering</h2>
            <p>
              This page was rendered on the server at:{" "}
              <code className={styles.code}>{renderTime}</code>
            </p>
            <p>
              This is request number:{" "}
              <code className={styles.code}>{requestCount}</code>
            </p>
          </div>

          <div className={styles.card}>
            <h2>Features</h2>
            <ul>
              <li>✅ Server-side rendering</li>
              <li>✅ TypeScript support</li>
              <li>✅ cPanel deployment ready</li>
              <li>✅ Custom server configuration</li>
            </ul>
          </div>
        </div>

        <div className={styles.grid}>
          <Link href="/" className={styles.card}>
            <h2>&larr; Back to Home</h2>
            <p>Return to the main page</p>
          </Link>
        </div>
      </main>

      <footer className={styles.footer}>
        <p>Next.js SSR Demo for cPanel Deployment</p>
      </footer>
    </div>
  );
}

export const getServerSideProps: GetServerSideProps = async () => {
  requestCounter++;

  return {
    props: {
      renderTime: new Date().toISOString(),
      requestCount: requestCounter,
    },
  };
};
