import type { NextApiRequest, NextApiResponse } from "next";

type Data = {
  message: string;
  timestamp: string;
  method: string;
  userAgent?: string;
};

export default function handler(
  req: NextApiRequest,
  res: NextApiResponse<Data>
) {
  res.status(200).json({
    message: "Hello from Next.js API route!",
    timestamp: new Date().toISOString(),
    method: req.method || "Unknown",
    userAgent: req.headers["user-agent"],
  });
}
